/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.es;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_es extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Cape_Verde = new String[] {
               "Hora est\u00e1ndar de Cabo Verde",
               "CVST",
               "Hora de verano de Cabo Verde",
               "CVST",
               "Hora de Cabo Verde",
               "CVT",
            };
        final String[] GMT = new String[] {
               "Hora media de Greenwich",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Omsk = new String[] {
               "Hora est\u00e1ndar de Omsk",
               "OST",
               "Hora de verano de Omsk",
               "OST",
               "Hora de Omsk",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora est\u00e1ndar de Haw\u00e1i-Aleutianas",
               "HAST",
               "Hora de verano de Haw\u00e1i-Aleutianas",
               "HADT",
               "Hora de Haw\u00e1i-Aleutianas",
               "HAT",
            };
        final String[] Myanmar = new String[] {
               "Hora de Myanmar",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Sakhalin = new String[] {
               "Hora est\u00e1ndar de Sajal\u00edn",
               "SST",
               "Hora de verano de Sajal\u00edn",
               "SST",
               "Hora de Sajal\u00edn",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Hora est\u00e1ndar de Yakutsk",
               "YST",
               "Hora de verano de Yakutsk",
               "YST",
               "Hora de Yakutsk",
               "YT",
            };
        final String[] Paraguay = new String[] {
               "Hora est\u00e1ndar de Paraguay",
               "PST",
               "Hora de verano de Paraguay",
               "PST",
               "Hora de Paraguay",
               "PT",
            };
        final String[] Nepal = new String[] {
               "Hora de Nepal",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora est\u00e1ndar de Turkmenist\u00e1n",
               "TST",
               "Hora de verano de Turkmenist\u00e1n",
               "TST",
               "Hora de Turkmenist\u00e1n",
               "TT",
            };
        final String[] Japan = new String[] {
               "Hora est\u00e1ndar de Jap\u00f3n",
               "JST",
               "Hora de verano de Jap\u00f3n",
               "JDT",
               "Hora de Jap\u00f3n",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Hora est\u00e1ndar de Vladivostok",
               "VST",
               "Hora de verano de Vladivostok",
               "VST",
               "Hora de Vladivostok",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Hora est\u00e1ndar de Europa Occidental",
               "WEST",
               "Hora de verano de Europa Occidental",
               "WEST",
               "Hora de Europa Occidental",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "Hora de Bangladesh",
               "BST",
               "Bangladesh Summer Time",
               "BST",
               "Bangladesh Time",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Oriental",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "Hora est\u00e1ndar de Groenlandia occidental",
               "WGST",
               "Hora de verano de Groenlandia occidental",
               "WGST",
               "Hora de Groenlandia occidental",
               "WGT",
            };
        final String[] Colombia = new String[] {
               "Hora est\u00e1ndar de Colombia",
               "CST",
               "Hora de verano de Colombia",
               "CST",
               "Hora de Colombia",
               "CT",
            };
        final String[] Suriname = new String[] {
               "Hora de Surinam",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Gulf = new String[] {
               "Hora est\u00e1ndar del Golfo",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Hovd = new String[] {
               "Hora est\u00e1ndar de Hovd",
               "HST",
               "Hora de verano de Hovd",
               "HST",
               "Hora de Hovd",
               "HT",
            };
        final String[] Amazon = new String[] {
               "Hora est\u00e1ndar del Amazonas",
               "AST",
               "Hora de verano del Amazonas",
               "AST",
               "Hora del Amazonas",
               "AT",
            };
        final String[] Pakistan = new String[] {
               "Hora est\u00e1ndar de Pakist\u00e1n",
               "PST",
               "Hora de verano de Pakist\u00e1n",
               "PST",
               "Hora de Pakist\u00e1n",
               "PT",
            };
        final String[] Mongolia = new String[] {
               "Hora est\u00e1ndar de Ul\u00e1n Bator",
               "UBST",
               "Hora de verano de Ul\u00e1n Bator",
               "UBST",
               "Hora de Ul\u00e1n Bator",
               "UBT",
            };
        final String[] America_Pacific = new String[] {
               "Hora est\u00e1ndar del Pac\u00edfico",
               "PST",
               "Hora de verano del Pac\u00edfico",
               "PDT",
               "Hora del Pac\u00edfico",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Hora est\u00e1ndar de Argentina occidental",
               "WAST",
               "Hora de verano de Argentina occidental",
               "WAST",
               "Hora de Argentina occidental",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "Hora de Gal\u00e1pagos",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "Hora de la Guayana Francesa",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hora est\u00e1ndar de Groenlandia oriental",
               "EGST",
               "Hora de verano de Groenlandia oriental",
               "EGST",
               "Hora de Groenlandia oriental",
               "EGT",
            };
        final String[] Volgograd = new String[] {
               "Hora est\u00e1ndar de Volgogrado",
               "VST",
               "Hora de verano de Volgogrado",
               "VST",
               "Hora de Volgogrado",
               "VT",
            };
        final String[] Korea = new String[] {
               "Hora est\u00e1ndar de Corea",
               "KST",
               "Hora de verano de Corea",
               "KDT",
               "Hora de Corea",
               "KT",
            };
        final String[] Argentina = new String[] {
               "Hora est\u00e1ndar de Argentina",
               "AST",
               "Hora de verano de Argentina",
               "AST",
               "Hora de Argentina",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "Hora est\u00e1ndar de Lord Howe",
               "LHST",
               "Hora de verano de Lord Howe",
               "LHDT",
               "Hora de Lord Howe",
               "LHT",
            };
        final String[] Kyrgystan = new String[] {
               "Hora de Kirguist\u00e1n",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Arabian = new String[] {
               "Hora est\u00e1ndar de Arabia",
               "AST",
               "Hora de verano de Arabia",
               "ADT",
               "Hora de Arabia",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora est\u00e1ndar de Australia oriental",
               "AEST",
               "Hora de verano de Australia oriental",
               "AEDT",
               "Hora de Australia oriental",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Hora est\u00e1ndar de Irkutsk",
               "IST",
               "Hora de verano de Irkutsk",
               "IST",
               "Hora de Irkutsk",
               "IT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora del Oc\u00e9ano \u00cdndico",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Hora est\u00e1ndar de Choibalsan",
               "CST",
               "Hora de verano de Choibalsan",
               "CST",
               "Hora de Choibalsan",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Hora est\u00e1ndar oriental",
               "EST",
               "Hora de verano oriental",
               "EDT",
               "Hora oriental",
               "ET",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora est\u00e1ndar de Australia centroccidental",
               "ACWST",
               "Hora de verano de Australia centroccidental",
               "ACWDT",
               "Hora de Australia centroccidental",
               "ACWT",
            };
        final String[] Australia_Western = new String[] {
               "Hora est\u00e1ndar de Australia occidental",
               "AWST",
               "Hora de verano de Australia occidental",
               "AWDT",
               "Hora de Australia occidental",
               "WAT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora est\u00e1ndar de Krasnoyarsk",
               "KST",
               "Hora de verano de Krasnoyarsk",
               "KST",
               "Hora de Krasnoyarsk",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora de Indonesia oriental",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "Hora de Venezuela",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Bhutan = new String[] {
               "Hora de But\u00e1n",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "Hora est\u00e1ndar de Fernando de Noronha",
               "FNST",
               "Hora de verano de Fernando de Noronha",
               "FNST",
               "Hora de Fernando de Noronha",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora est\u00e1ndar de Novosibirsk",
               "NST",
               "Hora de verano de Novosibirsk",
               "NST",
               "Hora de Novosibirsk",
               "NT",
            };
        final String[] Malaysia = new String[] {
               "Hora de Malasia",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Mountain = new String[] {
               "Hora est\u00e1ndar de Monta\u00f1a",
               "MST",
               "Hora de verano de Monta\u00f1a",
               "MDT",
               "Hora de las Monta\u00f1as",
               "MT",
            };
        final String[] Alaska = new String[] {
               "Hora est\u00e1ndar de Alaska",
               "AKST",
               "Hora de verano de Alaska",
               "AKDT",
               "Hora de Alaska",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "Hora est\u00e1ndar de Armenia",
               "AST",
               "Hora de verano de Armenia",
               "AST",
               "Hora de Armenia",
               "AT",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora de las Islas Marshall",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "Hora est\u00e1ndar de Australia central",
               "ACST",
               "Hora de verano de Australia central",
               "ACDT",
               "Hora de Australia central",
               "CAT",
            };
        final String[] Azores = new String[] {
               "Hora est\u00e1ndar de las Azores",
               "AST",
               "Hora de verano de las Azores",
               "AST",
               "Hora de las Azores",
               "AT",
            };
        final String[] Indochina = new String[] {
               "Hora de Indochina",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "Hora de Ecuador",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "Hora est\u00e1ndar de Magad\u00e1n",
               "MST",
               "Hora de verano de Magad\u00e1n",
               "MST",
               "Hora de Magad\u00e1n",
               "MT",
            };
        final String[] Cuba = new String[] {
               "Hora est\u00e1ndar de Cuba",
               "CST",
               "Hora de verano de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Hora est\u00e1ndar de \u00c1frica occidental",
               "WAST",
               "Hora de verano de \u00c1frica occidental",
               "WAST",
               "Hora de \u00c1frica occidental",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "Hora est\u00e1ndar de Mosc\u00fa",
               "MST",
               "Hora de verano de Mosc\u00fa",
               "MST",
               "Hora de Mosc\u00fa",
               "MT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora de Kazajist\u00e1n oriental",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "Hora est\u00e1ndar de Nueva Zelanda",
               "NZST",
               "Hora de verano de Nueva Zelanda",
               "NZDT",
               "Hora de Nueva Zelanda",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "Hora est\u00e1ndar de Hong Kong",
               "HKST",
               "Hora de verano de Hong Kong",
               "HKST",
               "Hora de Hong Kong",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "Hora est\u00e1ndar de Brasilia",
               "BST",
               "Hora de verano de Brasilia",
               "BST",
               "Hora de Brasilia",
               "BT",
            };
        final String[] Afghanistan = new String[] {
               "Hora de Afganist\u00e1n",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora de Indonesia occidental",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Africa_Central = new String[] {
               "Hora de \u00c1frica central",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] South_Georgia = new String[] {
               "Hora de Georgia meridional",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora de Indonesia central",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Philippines = new String[] {
               "Hora est\u00e1ndar de Filipinas",
               "PST",
               "Hora de verano de Filipinas",
               "PST",
               "Hora de Filipinas",
               "PT",
            };
        final String[] Georgia = new String[] {
               "Hora est\u00e1ndar de Georgia",
               "GST",
               "Hora de verano de Georgia",
               "GST",
               "Hora de Georgia",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "Hora de Bolivia",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Hora est\u00e1ndar de Per\u00fa",
               "PST",
               "Hora de verano de Per\u00fa",
               "PST",
               "Hora de Per\u00fa",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "Hora est\u00e1ndar de Chamorro",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "Hora est\u00e1ndar de Terranova",
               "NST",
               "Hora de verano de Terranova",
               "NDT",
               "Hora de Terranova",
               "NT",
            };
        final String[] America_Central = new String[] {
               "Hora est\u00e1ndar central",
               "CST",
               "Hora de verano central",
               "CDT",
               "Hora central",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora de \u00c1frica oriental",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "Hora est\u00e1ndar de Azerbaiy\u00e1n",
               "AST",
               "Hora de verano de Azerbaiy\u00e1n",
               "AST",
               "Hora de Azerbaiy\u00e1n",
               "AT",
            };
        final String[] Guyana = new String[] {
               "Hora de la Guyana",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora est\u00e1ndar de Yekaterinburgo",
               "YST",
               "Hora de verano de Yekaterinburgo",
               "YST",
               "Hora de Ekaterimburgo",
               "YT",
            };
        final String[] China = new String[] {
               "Hora est\u00e1ndar de China",
               "CST",
               "Hora de verano de China",
               "CDT",
               "Hora de China",
               "CT",
            };
        final String[] Samoa = new String[] {
               "Hora est\u00e1ndar de Samoa",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Africa_Southern = new String[] {
               "Hora de Sud\u00e1frica",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Hora de Macquarie",
               "MIT",
            };
        final String[] Chile = new String[] {
               "Hora est\u00e1ndar de Chile",
               "CST",
               "Hora de verano de Chile",
               "CST",
               "Hora de Chile",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora de Kazajist\u00e1n occidental",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "Hora est\u00e1ndar de Israel",
               "IST",
               "Hora de verano de Israel",
               "IDT",
               "Hora de Israel",
               "IT",
            };
        final String[] Tajikistan = new String[] {
               "Hora de Tayikist\u00e1n",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora est\u00e1ndar de San Pedro y Miquel\u00f3n",
               "PMST",
               "Hora de verano de San Pedro y Miquel\u00f3n",
               "PMDT",
               "Hora de San Pedro y Miquel\u00f3n",
               "PMT",
            };
        final String[] Europe_Central = new String[] {
               "Hora est\u00e1ndar de Europa Central",
               "CEST",
               "Hora de verano de Europa Central",
               "CEST",
               "Hora de Europa Central",
               "CET",
            };
        final String[] India = new String[] {
               "Hora est\u00e1ndar de la India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Uzbekistan = new String[] {
               "Hora est\u00e1ndar de Uzbekist\u00e1n",
               "UST",
               "Hora de verano de Uzbekist\u00e1n",
               "UST",
               "Hora de Uzbekist\u00e1n",
               "UT",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora est\u00e1ndar de Europa del Este",
               "EEST",
               "Hora de verano de Europa del Este",
               "EEST",
               "Hora de Europa del Este",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Hora est\u00e1ndar del Atl\u00e1ntico",
               "AST",
               "Hora de verano del Atl\u00e1ntico",
               "ADT",
               "Hora del Atl\u00e1ntico",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "Hora est\u00e1ndar de Uruguay",
               "UST",
               "Hora de verano de Uruguay",
               "UST",
               "Hora de Uruguay",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "Asia/Kuching", Malaysia },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Asia/Tashkent", Uzbekistan },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Pacific/Auckland", New_Zealand },
            { "Africa/Nairobi", Africa_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Africa/Bissau", GMT },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "Europe/Rome", Europe_Central },
            { "America/Lima", Peru },
            { "America/Dawson_Creek", America_Mountain },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Anadyr", Magadan },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Hermosillo", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/Boise", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Asia/Muscat", Gulf },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Asia/Karachi", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "America/Nome", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Guatemala", America_Central },
            { "Europe/Oslo", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Dubai", Gulf },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "America/Barbados", Atlantic },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Asia/Urumqi", China },
            { "America/Louisville", America_Eastern },
            { "Asia/Gaza", Europe_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Africa/Abidjan", GMT },
            { "Europe/Malta", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Europe/Madrid", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "Asia/Kabul", Afghanistan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Asia/Samarkand", Uzbekistan },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
