/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CheckedExceptionElement;
import sun.jvm.hotspot.oops.CompressedLineNumberReadStream;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ExceptionTableElement;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.LineNumberTableElement;
import sun.jvm.hotspot.oops.LocalVariableTableElement;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.MetadataVisitor;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.MethodArray;

public class ConstMethod
extends VMObject {
    private static int HAS_LINENUMBER_TABLE;
    private static int HAS_CHECKED_EXCEPTIONS;
    private static int HAS_LOCALVARIABLE_TABLE;
    private static int HAS_EXCEPTION_TABLE;
    private static int HAS_GENERIC_SIGNATURE;
    private static int HAS_METHOD_ANNOTATIONS;
    private static int HAS_PARAMETER_ANNOTATIONS;
    private static int HAS_METHOD_PARAMETERS;
    private static int HAS_DEFAULT_ANNOTATIONS;
    private static int HAS_TYPE_ANNOTATIONS;
    private static final int sizeofShort = 2;
    private static MetadataField constants;
    private static CIntField constMethodSize;
    private static CIntField flags;
    private static CIntField codeSize;
    private static CIntField nameIndex;
    private static CIntField signatureIndex;
    private static CIntField idnum;
    private static CIntField maxStack;
    private static CIntField maxLocals;
    private static CIntField sizeOfParameters;
    private static long bytecodeOffset;
    private static long methodParametersElementSize;
    private static long checkedExceptionElementSize;
    private static long localVariableTableElementSize;
    private static long exceptionTableElementSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ConstMethod");
        constants = new MetadataField(type.getAddressField("_constants"), 0L);
        constMethodSize = new CIntField(type.getCIntegerField("_constMethod_size"), 0L);
        flags = new CIntField(type.getCIntegerField("_flags"), 0L);
        HAS_LINENUMBER_TABLE = db.lookupIntConstant("ConstMethod::_has_linenumber_table");
        HAS_CHECKED_EXCEPTIONS = db.lookupIntConstant("ConstMethod::_has_checked_exceptions");
        HAS_LOCALVARIABLE_TABLE = db.lookupIntConstant("ConstMethod::_has_localvariable_table");
        HAS_EXCEPTION_TABLE = db.lookupIntConstant("ConstMethod::_has_exception_table");
        HAS_GENERIC_SIGNATURE = db.lookupIntConstant("ConstMethod::_has_generic_signature");
        HAS_METHOD_ANNOTATIONS = db.lookupIntConstant("ConstMethod::_has_method_annotations");
        HAS_PARAMETER_ANNOTATIONS = db.lookupIntConstant("ConstMethod::_has_parameter_annotations");
        HAS_METHOD_PARAMETERS = db.lookupIntConstant("ConstMethod::_has_method_parameters");
        HAS_DEFAULT_ANNOTATIONS = db.lookupIntConstant("ConstMethod::_has_default_annotations");
        HAS_TYPE_ANNOTATIONS = db.lookupIntConstant("ConstMethod::_has_type_annotations");
        codeSize = new CIntField(type.getCIntegerField("_code_size"), 0L);
        nameIndex = new CIntField(type.getCIntegerField("_name_index"), 0L);
        signatureIndex = new CIntField(type.getCIntegerField("_signature_index"), 0L);
        idnum = new CIntField(type.getCIntegerField("_method_idnum"), 0L);
        maxStack = new CIntField(type.getCIntegerField("_max_stack"), 0L);
        maxLocals = new CIntField(type.getCIntegerField("_max_locals"), 0L);
        sizeOfParameters = new CIntField(type.getCIntegerField("_size_of_parameters"), 0L);
        bytecodeOffset = type.getSize();
        type = db.lookupType("MethodParametersElement");
        methodParametersElementSize = type.getSize();
        type = db.lookupType("CheckedExceptionElement");
        checkedExceptionElementSize = type.getSize();
        type = db.lookupType("LocalVariableTableElement");
        localVariableTableElementSize = type.getSize();
        type = db.lookupType("ExceptionTableElement");
        exceptionTableElementSize = type.getSize();
    }

    public ConstMethod(Address addr) {
        super(addr);
    }

    public Method getMethod() {
        InstanceKlass ik = this.getConstants().getPoolHolder();
        MethodArray methods = ik.getMethods();
        return methods.at((int)this.getIdNum());
    }

    public ConstantPool getConstants() {
        return (ConstantPool)constants.getValue(this);
    }

    public long getConstMethodSize() {
        return constMethodSize.getValue(this);
    }

    public long getFlags() {
        return flags.getValue(this);
    }

    public long getCodeSize() {
        return codeSize.getValue(this);
    }

    public long getNameIndex() {
        return nameIndex.getValue(this);
    }

    public long getSignatureIndex() {
        return signatureIndex.getValue(this);
    }

    public long getGenericSignatureIndex() {
        if (this.hasGenericSignature()) {
            return this.getAddress().getCIntegerAt(this.offsetOfGenericSignatureIndex(), 2L, true);
        }
        return 0L;
    }

    public long getIdNum() {
        return idnum.getValue(this);
    }

    public long getMaxStack() {
        return maxStack.getValue(this);
    }

    public long getMaxLocals() {
        return maxLocals.getValue(this);
    }

    public long getSizeOfParameters() {
        return sizeOfParameters.getValue(this);
    }

    public Symbol getName() {
        return this.getMethod().getName();
    }

    public Symbol getSignature() {
        return this.getMethod().getSignature();
    }

    public Symbol getGenericSignature() {
        return this.getMethod().getGenericSignature();
    }

    public int getBytecodeOrBPAt(int bci) {
        return this.getAddress().getJByteAt(bytecodeOffset + (long)bci) & 0xFF;
    }

    public byte getBytecodeByteArg(int bci) {
        return (byte)this.getBytecodeOrBPAt(bci);
    }

    public short getBytecodeShortArg(int bci) {
        int hi = this.getBytecodeOrBPAt(bci);
        int lo = this.getBytecodeOrBPAt(bci + 1);
        return (short)(hi << 8 | lo);
    }

    public short getNativeShortArg(int bci) {
        int hi = this.getBytecodeOrBPAt(bci);
        int lo = this.getBytecodeOrBPAt(bci + 1);
        if (VM.getVM().isBigEndian()) {
            return (short)(hi << 8 | lo);
        }
        return (short)(lo << 8 | hi);
    }

    public int getBytecodeIntArg(int bci) {
        int b4 = this.getBytecodeOrBPAt(bci);
        int b3 = this.getBytecodeOrBPAt(bci + 1);
        int b2 = this.getBytecodeOrBPAt(bci + 2);
        int b1 = this.getBytecodeOrBPAt(bci + 3);
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    public int getNativeIntArg(int bci) {
        int b4 = this.getBytecodeOrBPAt(bci);
        int b3 = this.getBytecodeOrBPAt(bci + 1);
        int b2 = this.getBytecodeOrBPAt(bci + 2);
        int b1 = this.getBytecodeOrBPAt(bci + 3);
        if (VM.getVM().isBigEndian()) {
            return b4 << 24 | b3 << 16 | b2 << 8 | b1;
        }
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public byte[] getByteCode() {
        byte[] bc = new byte[(int)this.getCodeSize()];
        for (int i = 0; i < bc.length; ++i) {
            long offs = bytecodeOffset + (long)i;
            bc[i] = this.getAddress().getJByteAt(offs);
        }
        return bc;
    }

    public long getSize() {
        return this.getConstMethodSize();
    }

    public void printValueOn(PrintStream tty) {
        tty.print("ConstMethod " + this.getName().asString() + this.getSignature().asString() + "@" + this.getAddress());
    }

    public void iterateFields(MetadataVisitor visitor) {
        visitor.doMetadata(constants, true);
        visitor.doCInt(constMethodSize, true);
        visitor.doCInt(flags, true);
        visitor.doCInt(codeSize, true);
        visitor.doCInt(nameIndex, true);
        visitor.doCInt(signatureIndex, true);
        visitor.doCInt(codeSize, true);
        visitor.doCInt(maxStack, true);
        visitor.doCInt(maxLocals, true);
        visitor.doCInt(sizeOfParameters, true);
    }

    public boolean hasLineNumberTable() {
        return (this.getFlags() & (long)HAS_LINENUMBER_TABLE) != 0L;
    }

    public int getLineNumberFromBCI(int bci) {
        if (!VM.getVM().isCore() && bci == -1) {
            bci = 0;
        }
        if (this.isNative()) {
            return -1;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(bci == 0 || 0 <= bci && (long)bci < this.getCodeSize(), "illegal bci");
        }
        int bestBCI = 0;
        int bestLine = -1;
        if (this.hasLineNumberTable()) {
            CompressedLineNumberReadStream stream = new CompressedLineNumberReadStream(this.getAddress(), (int)this.offsetOfCompressedLineNumberTable());
            while (stream.readPair()) {
                if (stream.bci() == bci) {
                    return stream.line();
                }
                if (stream.bci() >= bci || stream.bci() < bestBCI) continue;
                bestBCI = stream.bci();
                bestLine = stream.line();
            }
        }
        return bestLine;
    }

    public LineNumberTableElement[] getLineNumberTable() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasLineNumberTable(), "should only be called if table is present");
        }
        int len = this.getLineNumberTableLength();
        CompressedLineNumberReadStream stream = new CompressedLineNumberReadStream(this.getAddress(), (int)this.offsetOfCompressedLineNumberTable());
        LineNumberTableElement[] ret = new LineNumberTableElement[len];
        for (int idx = 0; idx < len; ++idx) {
            stream.readPair();
            ret[idx] = new LineNumberTableElement(stream.bci(), stream.line());
        }
        return ret;
    }

    public boolean hasLocalVariableTable() {
        return (this.getFlags() & (long)HAS_LOCALVARIABLE_TABLE) != 0L;
    }

    public Symbol getLocalVariableName(int bci, int slot) {
        return this.getMethod().getLocalVariableName(bci, slot);
    }

    public LocalVariableTableElement[] getLocalVariableTable() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasLocalVariableTable(), "should only be called if table is present");
        }
        LocalVariableTableElement[] ret = new LocalVariableTableElement[this.getLocalVariableTableLength()];
        long offset = this.offsetOfLocalVariableTable();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new LocalVariableTableElement(this.getAddress(), offset);
            offset += localVariableTableElementSize;
        }
        return ret;
    }

    public boolean hasExceptionTable() {
        return (this.getFlags() & (long)HAS_EXCEPTION_TABLE) != 0L;
    }

    public ExceptionTableElement[] getExceptionTable() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasExceptionTable(), "should only be called if table is present");
        }
        ExceptionTableElement[] ret = new ExceptionTableElement[this.getExceptionTableLength()];
        long offset = this.offsetOfExceptionTable();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new ExceptionTableElement(this.getAddress(), offset);
            offset += exceptionTableElementSize;
        }
        return ret;
    }

    public boolean hasCheckedExceptions() {
        return (this.getFlags() & (long)HAS_CHECKED_EXCEPTIONS) != 0L;
    }

    public CheckedExceptionElement[] getCheckedExceptions() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasCheckedExceptions(), "should only be called if table is present");
        }
        CheckedExceptionElement[] ret = new CheckedExceptionElement[this.getCheckedExceptionsLength()];
        long offset = this.offsetOfCheckedExceptions();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new CheckedExceptionElement(this.getAddress(), offset);
            offset += checkedExceptionElementSize;
        }
        return ret;
    }

    private boolean hasMethodParameters() {
        return (this.getFlags() & (long)HAS_METHOD_PARAMETERS) != 0L;
    }

    private boolean hasGenericSignature() {
        return (this.getFlags() & (long)HAS_GENERIC_SIGNATURE) != 0L;
    }

    private boolean hasMethodAnnotations() {
        return (this.getFlags() & (long)HAS_METHOD_ANNOTATIONS) != 0L;
    }

    private boolean hasParameterAnnotations() {
        return (this.getFlags() & (long)HAS_PARAMETER_ANNOTATIONS) != 0L;
    }

    private boolean hasDefaultAnnotations() {
        return (this.getFlags() & (long)HAS_DEFAULT_ANNOTATIONS) != 0L;
    }

    private boolean hasTypeAnnotations() {
        return (this.getFlags() & (long)HAS_TYPE_ANNOTATIONS) != 0L;
    }

    private boolean isNative() {
        return this.getMethod().isNative();
    }

    private long offsetOfCodeEnd() {
        return bytecodeOffset + this.getCodeSize();
    }

    private long offsetOfCompressedLineNumberTable() {
        return this.offsetOfCodeEnd() + (this.isNative() ? 2L * VM.getVM().getAddressSize() : 0L);
    }

    private long offsetOfLastU2Element() {
        int offset = 0;
        if (this.hasMethodAnnotations()) {
            ++offset;
        }
        if (this.hasParameterAnnotations()) {
            ++offset;
        }
        if (this.hasTypeAnnotations()) {
            ++offset;
        }
        if (this.hasDefaultAnnotations()) {
            ++offset;
        }
        long wordSize = VM.getVM().getObjectHeap().getOopSize();
        return this.getSize() * wordSize - (long)offset * wordSize - 2L;
    }

    private long offsetOfGenericSignatureIndex() {
        return this.offsetOfLastU2Element();
    }

    private long offsetOfMethodParametersLength() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasMethodParameters(), "should only be called if table is present");
        }
        return this.hasGenericSignature() ? this.offsetOfLastU2Element() - 2L : this.offsetOfLastU2Element();
    }

    private int getMethodParametersLength() {
        if (this.hasMethodParameters()) {
            return (int)this.getAddress().getCIntegerAt(this.offsetOfMethodParametersLength(), 2L, true);
        }
        return 0;
    }

    private long offsetOfMethodParameters() {
        long offset = this.offsetOfMethodParametersLength();
        long length = this.getMethodParametersLength();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(length > 0L, "should only be called if method parameter information is present");
        }
        return offset -= length * methodParametersElementSize;
    }

    private long offsetOfCheckedExceptionsLength() {
        if (this.hasMethodParameters()) {
            return this.offsetOfMethodParameters() - 2L;
        }
        return this.hasGenericSignature() ? this.offsetOfLastU2Element() - 2L : this.offsetOfLastU2Element();
    }

    private int getCheckedExceptionsLength() {
        if (this.hasCheckedExceptions()) {
            return (int)this.getAddress().getCIntegerAt(this.offsetOfCheckedExceptionsLength(), 2L, true);
        }
        return 0;
    }

    private long offsetOfCheckedExceptions() {
        long offset = this.offsetOfCheckedExceptionsLength();
        long length = this.getCheckedExceptionsLength();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(length > 0L, "should only be called if table is present");
        }
        return offset -= length * checkedExceptionElementSize;
    }

    private int getLineNumberTableLength() {
        int len = 0;
        if (this.hasLineNumberTable()) {
            CompressedLineNumberReadStream stream = new CompressedLineNumberReadStream(this.getAddress(), (int)this.offsetOfCompressedLineNumberTable());
            while (stream.readPair()) {
                ++len;
            }
        }
        return len;
    }

    private int getLocalVariableTableLength() {
        if (this.hasLocalVariableTable()) {
            return (int)this.getAddress().getCIntegerAt(this.offsetOfLocalVariableTableLength(), 2L, true);
        }
        return 0;
    }

    private long offsetOfLocalVariableTableLength() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasLocalVariableTable(), "should only be called if table is present");
        }
        if (this.hasExceptionTable()) {
            return this.offsetOfExceptionTable() - 2L;
        }
        if (this.hasCheckedExceptions()) {
            return this.offsetOfCheckedExceptions() - 2L;
        }
        if (this.hasMethodParameters()) {
            return this.offsetOfMethodParameters() - 2L;
        }
        return this.hasGenericSignature() ? this.offsetOfLastU2Element() - 2L : this.offsetOfLastU2Element();
    }

    private long offsetOfLocalVariableTable() {
        long offset = this.offsetOfLocalVariableTableLength();
        long length = this.getLocalVariableTableLength();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(length > 0L, "should only be called if table is present");
        }
        return offset -= length * localVariableTableElementSize;
    }

    private int getExceptionTableLength() {
        if (this.hasExceptionTable()) {
            return (int)this.getAddress().getCIntegerAt(this.offsetOfExceptionTableLength(), 2L, true);
        }
        return 0;
    }

    private long offsetOfExceptionTableLength() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasExceptionTable(), "should only be called if table is present");
        }
        if (this.hasCheckedExceptions()) {
            return this.offsetOfCheckedExceptions() - 2L;
        }
        if (this.hasMethodParameters()) {
            return this.offsetOfMethodParameters() - 2L;
        }
        return this.hasGenericSignature() ? this.offsetOfLastU2Element() - 2L : this.offsetOfLastU2Element();
    }

    private long offsetOfExceptionTable() {
        long offset = this.offsetOfExceptionTableLength();
        long length = this.getExceptionTableLength();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(length > 0L, "should only be called if table is present");
        }
        return offset -= length * exceptionTableElementSize;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ConstMethod.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

