/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.net.InetAddress;
import java.util.List;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTab;
import sun.security.krb5.internal.ktab.KeyTabEntry;

public class Klist {
    Object target;
    char[] options = new char[4];
    String name;
    char action;
    private static boolean DEBUG = Krb5.DEBUG;

    public static void main(String[] stringArray) {
        Klist klist = new Klist();
        if (stringArray == null || stringArray.length == 0) {
            klist.action = (char)99;
        } else {
            klist.processArgs(stringArray);
        }
        switch (klist.action) {
            case 'c': {
                if (klist.name == null) {
                    klist.target = CredentialsCache.getInstance();
                    klist.name = CredentialsCache.cacheName();
                } else {
                    klist.target = CredentialsCache.getInstance(klist.name);
                }
                if (klist.target != null) {
                    klist.displayCache();
                    break;
                }
                klist.displayMessage("Credentials cache");
                System.exit(-1);
                break;
            }
            case 'k': {
                KeyTab keyTab = KeyTab.getInstance(klist.name);
                if (keyTab.isMissing()) {
                    System.out.println("KeyTab " + klist.name + " not found.");
                    System.exit(-1);
                } else if (!keyTab.isValid()) {
                    System.out.println("KeyTab " + klist.name + " format not supported.");
                    System.exit(-1);
                }
                klist.target = keyTab;
                klist.name = keyTab.tabName();
                klist.displayTab();
                break;
            }
            default: {
                if (klist.name != null) {
                    klist.printHelp();
                    System.exit(-1);
                    break;
                }
                klist.target = CredentialsCache.getInstance();
                klist.name = CredentialsCache.cacheName();
                if (klist.target != null) {
                    klist.displayCache();
                    break;
                }
                klist.displayMessage("Credentials cache");
                System.exit(-1);
            }
        }
    }

    void processArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Character c;
            if (stringArray[i].length() >= 2 && stringArray[i].startsWith("-")) {
                c = new Character(stringArray[i].charAt(1));
                switch (c.charValue()) {
                    case 'c': {
                        this.action = (char)99;
                        break;
                    }
                    case 'k': {
                        this.action = (char)107;
                        break;
                    }
                    case 'a': {
                        this.options[2] = 97;
                        break;
                    }
                    case 'n': {
                        this.options[3] = 110;
                        break;
                    }
                    case 'f': {
                        this.options[1] = 102;
                        break;
                    }
                    case 'e': {
                        this.options[0] = 101;
                        break;
                    }
                    case 'K': {
                        this.options[1] = 75;
                        break;
                    }
                    case 't': {
                        this.options[2] = 116;
                        break;
                    }
                    default: {
                        this.printHelp();
                        System.exit(-1);
                        break;
                    }
                }
                continue;
            }
            if (!stringArray[i].startsWith("-") && i == stringArray.length - 1) {
                this.name = stringArray[i];
                c = null;
                continue;
            }
            this.printHelp();
            System.exit(-1);
        }
    }

    void displayTab() {
        KeyTab keyTab = (KeyTab)this.target;
        KeyTabEntry[] keyTabEntryArray = keyTab.getEntries();
        if (keyTabEntryArray.length == 0) {
            System.out.println("\nKey tab: " + this.name + ",  0 entries found.\n");
        } else {
            if (keyTabEntryArray.length == 1) {
                System.out.println("\nKey tab: " + this.name + ", " + keyTabEntryArray.length + " entry found.\n");
            } else {
                System.out.println("\nKey tab: " + this.name + ", " + keyTabEntryArray.length + " entries found.\n");
            }
            for (int i = 0; i < keyTabEntryArray.length; ++i) {
                EncryptionKey encryptionKey;
                System.out.println("[" + (i + 1) + "] Service principal: " + keyTabEntryArray[i].getService().toString());
                System.out.println("\t KVNO: " + keyTabEntryArray[i].getKey().getKeyVersionNumber());
                if (this.options[0] == 'e') {
                    encryptionKey = keyTabEntryArray[i].getKey();
                    System.out.println("\t Key type: " + encryptionKey.getEType());
                }
                if (this.options[1] == 'K') {
                    encryptionKey = keyTabEntryArray[i].getKey();
                    System.out.println("\t Key: " + keyTabEntryArray[i].getKeyString());
                }
                if (this.options[2] != 't') continue;
                System.out.println("\t Time stamp: " + this.format(keyTabEntryArray[i].getTimeStamp()));
            }
        }
    }

    void displayCache() {
        CredentialsCache credentialsCache = (CredentialsCache)this.target;
        Credentials[] credentialsArray = credentialsCache.getCredsList();
        if (credentialsArray == null) {
            System.out.println("No credentials available in the cache " + this.name);
            System.exit(-1);
        }
        System.out.println("\nCredentials cache: " + this.name);
        String string = credentialsCache.getPrimaryPrincipal().toString();
        int n = credentialsArray.length;
        if (n == 1) {
            System.out.println("\nDefault principal: " + string + ", " + credentialsArray.length + " entry found.\n");
        } else {
            System.out.println("\nDefault principal: " + string + ", " + credentialsArray.length + " entries found.\n");
        }
        if (credentialsArray != null) {
            for (int i = 0; i < credentialsArray.length; ++i) {
                try {
                    InetAddress[] inetAddressArray;
                    String string2;
                    String string3 = credentialsArray[i].getStartTime() != null ? this.format(credentialsArray[i].getStartTime()) : this.format(credentialsArray[i].getAuthTime());
                    String object = this.format(credentialsArray[i].getEndTime());
                    String string4 = credentialsArray[i].getServicePrincipal().toString();
                    System.out.println("[" + (i + 1) + "]  Service Principal:  " + string4);
                    PrincipalName principalName = credentialsArray[i].getServicePrincipal2();
                    if (principalName != null) {
                        System.out.println("     Second Service:     " + principalName);
                    }
                    if (!(string2 = credentialsArray[i].getClientPrincipal().toString()).equals(string)) {
                        System.out.println("     Client Principal:   " + string2);
                    }
                    System.out.println("     Valid starting:     " + (String)string3);
                    System.out.println("     Expires:            " + object);
                    if (credentialsArray[i].getRenewTill() != null) {
                        String string5 = this.format(credentialsArray[i].getRenewTill());
                        System.out.println("     Renew until:        " + string5);
                    }
                    if (this.options[0] == 'e') {
                        String string6 = EType.toString(credentialsArray[i].getEType());
                        inetAddressArray = EType.toString(credentialsArray[i].getTktEType());
                        if (credentialsArray[i].getTktEType2() == 0) {
                            System.out.println("     EType (skey, tkt):  " + string6 + ", " + (String)inetAddressArray);
                        } else {
                            InetAddress[] inetAddressArray2 = EType.toString(credentialsArray[i].getTktEType2());
                            System.out.println("     EType (skey, tkts): " + string6 + ", " + (String)inetAddressArray + ", " + (String)inetAddressArray2);
                        }
                    }
                    if (this.options[1] == 'f') {
                        System.out.println("     Flags:              " + credentialsArray[i].getTicketFlags().toString());
                    }
                    if (this.options[2] != 'a') continue;
                    boolean bl = true;
                    inetAddressArray = credentialsArray[i].setKrbCreds().getClientAddresses();
                    if (inetAddressArray != null) {
                        for (InetAddress inetAddress : inetAddressArray) {
                            String string7 = this.options[3] == 'n' ? inetAddress.getHostAddress() : inetAddress.getCanonicalHostName();
                            System.out.println("     " + (bl ? "Addresses:" : "          ") + "       " + string7);
                            bl = false;
                        }
                        continue;
                    }
                    System.out.println("     [No host addresses info]");
                    continue;
                }
                catch (RealmException realmException) {
                    System.out.println("Error reading principal from the entry.");
                    if (DEBUG) {
                        realmException.printStackTrace();
                    }
                    System.exit(-1);
                }
            }
        } else {
            System.out.println("\nNo entries found.");
        }
        List<CredentialsCache.ConfigEntry> list = credentialsCache.getConfigEntries();
        if (list != null && !list.isEmpty()) {
            System.out.println("\nConfig entries:");
            for (CredentialsCache.ConfigEntry configEntry : list) {
                System.out.println("     " + configEntry);
            }
        }
    }

    void displayMessage(String string) {
        if (this.name == null) {
            System.out.println("Default " + string + " not found.");
        } else {
            System.out.println(string + " " + this.name + " not found.");
        }
    }

    private String format(KerberosTime kerberosTime) {
        String string = kerberosTime.toDate().toString();
        return string.substring(4, 7) + " " + string.substring(8, 10) + ", " + string.substring(24) + " " + string.substring(11, 19);
    }

    void printHelp() {
        System.out.println("\nUsage: klist [[-c] [-f] [-e] [-a [-n]]] [-k [-t] [-K]] [name]");
        System.out.println("   name\t name of credentials cache or  keytab with the prefix. File-based cache or keytab's prefix is FILE:.");
        System.out.println("   -c specifies that credential cache is to be listed");
        System.out.println("   -k specifies that key tab is to be listed");
        System.out.println("   options for credentials caches:");
        System.out.println("\t-f \t shows credentials flags");
        System.out.println("\t-e \t shows the encryption type");
        System.out.println("\t-a \t shows addresses");
        System.out.println("\t  -n \t   do not reverse-resolve addresses");
        System.out.println("   options for keytabs:");
        System.out.println("\t-t \t shows keytab entry timestamps");
        System.out.println("\t-K \t shows keytab entry key value");
        System.out.println("\t-e \t shows keytab entry key type");
        System.out.println("\nUsage: java sun.security.krb5.tools.Klist -help for help.");
    }
}

