/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalProgressBarUI
extends BasicProgressBarUI {
    private Rectangle innards;
    private Rectangle box;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalProgressBarUI();
    }

    @Override
    public void paintDeterminate(Graphics graphics, JComponent jComponent) {
        super.paintDeterminate(graphics, jComponent);
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.isBorderPainted()) {
            Insets insets = this.progressBar.getInsets();
            int n = this.progressBar.getWidth() - (insets.left + insets.right);
            int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
            int n3 = this.getAmountFull(insets, n, n2);
            boolean bl = MetalUtils.isLeftToRight(jComponent);
            int n4 = insets.left;
            int n5 = insets.top;
            int n6 = insets.left + n - 1;
            int n7 = insets.top + n2 - 1;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(1.0f));
            if (this.progressBar.getOrientation() == 0) {
                graphics2D.setColor(MetalLookAndFeel.getControlShadow());
                graphics2D.drawLine(n4, n5, n6, n5);
                if (n3 > 0) {
                    graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    if (bl) {
                        graphics2D.drawLine(n4, n5, n4 + n3 - 1, n5);
                    } else {
                        graphics2D.drawLine(n6, n5, n6 - n3 + 1, n5);
                        if (this.progressBar.getPercentComplete() != 1.0) {
                            graphics2D.setColor(MetalLookAndFeel.getControlShadow());
                        }
                    }
                }
                graphics2D.drawLine(n4, n5, n4, n7);
            } else {
                graphics2D.setColor(MetalLookAndFeel.getControlShadow());
                graphics2D.drawLine(n4, n5, n4, n7);
                if (n3 > 0) {
                    graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                    graphics2D.drawLine(n4, n7, n4, n7 - n3 + 1);
                }
                graphics2D.setColor(MetalLookAndFeel.getControlShadow());
                if (this.progressBar.getPercentComplete() == 1.0) {
                    graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                }
                graphics2D.drawLine(n4, n5, n6, n5);
            }
        }
    }

    @Override
    public void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        super.paintIndeterminate(graphics, jComponent);
        if (!this.progressBar.isBorderPainted() || !(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.left + insets.right);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n3 = this.getAmountFull(insets, n, n2);
        boolean bl = MetalUtils.isLeftToRight(jComponent);
        Rectangle rectangle = null;
        rectangle = this.getBox(rectangle);
        int n4 = insets.left;
        int n5 = insets.top;
        int n6 = insets.left + n - 1;
        int n7 = insets.top + n2 - 1;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (this.progressBar.getOrientation() == 0) {
            graphics2D.setColor(MetalLookAndFeel.getControlShadow());
            graphics2D.drawLine(n4, n5, n6, n5);
            graphics2D.drawLine(n4, n5, n4, n7);
            graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics2D.drawLine(rectangle.x, n5, rectangle.x + rectangle.width - 1, n5);
        } else {
            graphics2D.setColor(MetalLookAndFeel.getControlShadow());
            graphics2D.drawLine(n4, n5, n4, n7);
            graphics2D.drawLine(n4, n5, n6, n5);
            graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics2D.drawLine(n4, rectangle.y, n4, rectangle.y + rectangle.height - 1);
        }
    }
}

