/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.implementations.Canonicalizer11_OmitComments;
import com.sun.org.apache.xml.internal.security.c14n.implementations.Canonicalizer20010315;
import com.sun.org.apache.xml.internal.security.c14n.implementations.Canonicalizer20010315OmitComments;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityRuntimeException;
import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInputDebugger;
import com.sun.org.apache.xml.internal.security.utils.IgnoreAllErrorHandler;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLSignatureInput {
    private InputStream inputOctetStreamProxy;
    private Set<Node> inputNodeSet;
    private Node subNode;
    private Node excludeNode;
    private boolean excludeComments = false;
    private boolean isNodeSet = false;
    private byte[] bytes;
    private boolean secureValidation;
    private String mimeType;
    private String sourceURI;
    private List<NodeFilter> nodeFilters = new ArrayList<NodeFilter>();
    private boolean needsToBeExpanded = false;
    private OutputStream outputStream;
    private String preCalculatedDigest;

    public XMLSignatureInput(byte[] byArray) {
        this.bytes = byArray;
    }

    public XMLSignatureInput(InputStream inputStream) {
        this.inputOctetStreamProxy = inputStream;
    }

    public XMLSignatureInput(Node node) {
        this.subNode = node;
    }

    public XMLSignatureInput(Set<Node> set) {
        this.inputNodeSet = set;
    }

    public XMLSignatureInput(String string) {
        this.preCalculatedDigest = string;
    }

    public boolean isNeedsToBeExpanded() {
        return this.needsToBeExpanded;
    }

    public void setNeedsToBeExpanded(boolean bl) {
        this.needsToBeExpanded = bl;
    }

    public Set<Node> getNodeSet() throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        return this.getNodeSet(false);
    }

    public Set<Node> getInputNodeSet() {
        return this.inputNodeSet;
    }

    public Set<Node> getNodeSet(boolean bl) throws ParserConfigurationException, IOException, SAXException, CanonicalizationException {
        if (this.inputNodeSet != null) {
            return this.inputNodeSet;
        }
        if (this.inputOctetStreamProxy == null && this.subNode != null) {
            if (bl) {
                XMLUtils.circumventBug2650(XMLUtils.getOwnerDocument(this.subNode));
            }
            this.inputNodeSet = new LinkedHashSet<Node>();
            XMLUtils.getSet(this.subNode, this.inputNodeSet, this.excludeNode, this.excludeComments);
            return this.inputNodeSet;
        }
        if (this.isOctetStream()) {
            this.convertToNodes();
            LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
            XMLUtils.getSet(this.subNode, linkedHashSet, null, false);
            return linkedHashSet;
        }
        throw new RuntimeException("getNodeSet() called but no input data present");
    }

    public InputStream getOctetStream() throws IOException {
        if (this.inputOctetStreamProxy != null) {
            return this.inputOctetStreamProxy;
        }
        if (this.bytes != null) {
            this.inputOctetStreamProxy = new ByteArrayInputStream(this.bytes);
            return this.inputOctetStreamProxy;
        }
        return null;
    }

    public InputStream getOctetStreamReal() {
        return this.inputOctetStreamProxy;
    }

    public byte[] getBytes() throws IOException, CanonicalizationException {
        byte[] byArray = this.getBytesFromInputStream();
        if (byArray != null) {
            return byArray;
        }
        Canonicalizer20010315OmitComments canonicalizer20010315OmitComments = new Canonicalizer20010315OmitComments();
        this.bytes = canonicalizer20010315OmitComments.engineCanonicalize(this);
        return this.bytes;
    }

    public boolean isNodeSet() {
        return this.inputOctetStreamProxy == null && this.inputNodeSet != null || this.isNodeSet;
    }

    public boolean isElement() {
        return this.inputOctetStreamProxy == null && this.subNode != null && this.inputNodeSet == null && !this.isNodeSet;
    }

    public boolean isOctetStream() {
        return (this.inputOctetStreamProxy != null || this.bytes != null) && this.inputNodeSet == null && this.subNode == null;
    }

    public boolean isOutputStreamSet() {
        return this.outputStream != null;
    }

    public boolean isByteArray() {
        return this.bytes != null && this.inputNodeSet == null && this.subNode == null;
    }

    public boolean isPreCalculatedDigest() {
        return this.preCalculatedDigest != null;
    }

    public boolean isInitialized() {
        return this.isOctetStream() || this.isNodeSet();
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public void setMIMEType(String string) {
        this.mimeType = string;
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public void setSourceURI(String string) {
        this.sourceURI = string;
    }

    public String toString() {
        if (this.isNodeSet()) {
            return "XMLSignatureInput/NodeSet/" + this.inputNodeSet.size() + " nodes/" + this.getSourceURI();
        }
        if (this.isElement()) {
            return "XMLSignatureInput/Element/" + this.subNode + " exclude " + this.excludeNode + " comments:" + this.excludeComments + "/" + this.getSourceURI();
        }
        try {
            return "XMLSignatureInput/OctetStream/" + this.getBytes().length + " octets/" + this.getSourceURI();
        }
        catch (IOException iOException) {
            return "XMLSignatureInput/OctetStream//" + this.getSourceURI();
        }
        catch (CanonicalizationException canonicalizationException) {
            return "XMLSignatureInput/OctetStream//" + this.getSourceURI();
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        XMLSignatureInputDebugger xMLSignatureInputDebugger = new XMLSignatureInputDebugger(this);
        return xMLSignatureInputDebugger.getHTMLRepresentation();
    }

    public String getHTMLRepresentation(Set<String> set) throws XMLSignatureException {
        XMLSignatureInputDebugger xMLSignatureInputDebugger = new XMLSignatureInputDebugger(this, set);
        return xMLSignatureInputDebugger.getHTMLRepresentation();
    }

    public Node getExcludeNode() {
        return this.excludeNode;
    }

    public void setExcludeNode(Node node) {
        this.excludeNode = node;
    }

    public Node getSubNode() {
        return this.subNode;
    }

    public boolean isExcludeComments() {
        return this.excludeComments;
    }

    public void setExcludeComments(boolean bl) {
        this.excludeComments = bl;
    }

    public void updateOutputStream(OutputStream outputStream) throws CanonicalizationException, IOException {
        this.updateOutputStream(outputStream, false);
    }

    public void updateOutputStream(OutputStream outputStream, boolean bl) throws CanonicalizationException, IOException {
        if (outputStream == this.outputStream) {
            return;
        }
        if (this.bytes != null) {
            outputStream.write(this.bytes);
        } else if (this.inputOctetStreamProxy == null) {
            Canonicalizer20010315 canonicalizer20010315 = null;
            canonicalizer20010315 = bl ? new Canonicalizer11_OmitComments() : new Canonicalizer20010315OmitComments();
            canonicalizer20010315.setWriter(outputStream);
            canonicalizer20010315.engineCanonicalize(this);
        } else {
            byte[] byArray = new byte[4096];
            int n = 0;
            try {
                while ((n = this.inputOctetStreamProxy.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                this.inputOctetStreamProxy.close();
                throw iOException;
            }
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    private byte[] getBytesFromInputStream() throws IOException {
        if (this.bytes != null) {
            return this.bytes;
        }
        if (this.inputOctetStreamProxy == null) {
            return null;
        }
        try {
            this.bytes = JavaUtils.getBytesFromStream(this.inputOctetStreamProxy);
        }
        finally {
            this.inputOctetStreamProxy.close();
        }
        return this.bytes;
    }

    public void addNodeFilter(NodeFilter nodeFilter) {
        if (this.isOctetStream()) {
            try {
                this.convertToNodes();
            }
            catch (Exception exception) {
                throw new XMLSecurityRuntimeException("signature.XMLSignatureInput.nodesetReference", exception);
            }
        }
        this.nodeFilters.add(nodeFilter);
    }

    public List<NodeFilter> getNodeFilters() {
        return this.nodeFilters;
    }

    public void setNodeSet(boolean bl) {
        this.isNodeSet = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertToNodes() throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = XMLUtils.createDocumentBuilder(false, this.secureValidation);
        try {
            documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
            Document document = documentBuilder.parse(this.getOctetStream());
            this.subNode = document;
        }
        catch (SAXException sAXException) {
            byte[] byArray = null;
            try (Closeable closeable = new ByteArrayOutputStream();){
                ((OutputStream)closeable).write("<container>".getBytes(StandardCharsets.UTF_8));
                ((OutputStream)closeable).write(this.getBytes());
                ((OutputStream)closeable).write("</container>".getBytes(StandardCharsets.UTF_8));
                byArray = ((ByteArrayOutputStream)closeable).toByteArray();
            }
            closeable = new ByteArrayInputStream(byArray);
            var5_6 = null;
            try {
                Document document = documentBuilder.parse((InputStream)closeable);
                this.subNode = document.getDocumentElement().getFirstChild().getFirstChild();
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (var5_6 != null) {
                        try {
                            ((InputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)closeable).close();
                    }
                }
            }
        }
        finally {
            if (this.inputOctetStreamProxy != null) {
                this.inputOctetStreamProxy.close();
            }
            this.inputOctetStreamProxy = null;
            this.bytes = null;
        }
    }

    public boolean isSecureValidation() {
        return this.secureValidation;
    }

    public void setSecureValidation(boolean bl) {
        this.secureValidation = bl;
    }

    public String getPreCalculatedDigest() {
        return this.preCalculatedDigest;
    }
}

