/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import sun.awt.AppContext;
import sun.awt.EventQueueDelegate;
import sun.awt.SunToolkit;

public class SwingUtilities3 {
    private static final Object DELEGATE_REPAINT_MANAGER_KEY = new StringBuilder("DelegateRepaintManagerKey");
    private static final Map<Container, Boolean> vsyncedMap = Collections.synchronizedMap(new WeakHashMap());

    public static void setDelegateRepaintManager(JComponent jComponent, RepaintManager repaintManager) {
        AppContext.getAppContext().put(DELEGATE_REPAINT_MANAGER_KEY, Boolean.TRUE);
        jComponent.putClientProperty(DELEGATE_REPAINT_MANAGER_KEY, repaintManager);
    }

    public static void setVsyncRequested(Container container, boolean bl) {
        assert (container instanceof Applet || container instanceof Window);
        if (bl) {
            vsyncedMap.put(container, Boolean.TRUE);
        } else {
            vsyncedMap.remove(container);
        }
    }

    public static boolean isVsyncRequested(Container container) {
        assert (container instanceof Applet || container instanceof Window);
        return Boolean.TRUE == vsyncedMap.get(container);
    }

    public static RepaintManager getDelegateRepaintManager(Component component) {
        RepaintManager repaintManager = null;
        if (Boolean.TRUE == SunToolkit.targetToAppContext(component).get(DELEGATE_REPAINT_MANAGER_KEY)) {
            while (repaintManager == null && component != null) {
                while (component != null && !(component instanceof JComponent)) {
                    component = component.getParent();
                }
                if (component == null) continue;
                repaintManager = (RepaintManager)((JComponent)component).getClientProperty(DELEGATE_REPAINT_MANAGER_KEY);
                component = component.getParent();
            }
        }
        return repaintManager;
    }

    public static void setEventQueueDelegate(Map<String, Map<String, Object>> map) {
        EventQueueDelegate.setDelegate(new EventQueueDelegateFromMap(map));
    }

    private static class EventQueueDelegateFromMap
    implements EventQueueDelegate.Delegate {
        private final AWTEvent[] afterDispatchEventArgument;
        private final Object[] afterDispatchHandleArgument;
        private final Callable<Void> afterDispatchCallable;
        private final AWTEvent[] beforeDispatchEventArgument;
        private final Callable<Object> beforeDispatchCallable;
        private final EventQueue[] getNextEventEventQueueArgument;
        private final Callable<AWTEvent> getNextEventCallable;

        public EventQueueDelegateFromMap(Map<String, Map<String, Object>> map) {
            Map<String, Object> map2 = map.get("afterDispatch");
            this.afterDispatchEventArgument = (AWTEvent[])map2.get("event");
            this.afterDispatchHandleArgument = (Object[])map2.get("handle");
            this.afterDispatchCallable = (Callable)map2.get("method");
            map2 = map.get("beforeDispatch");
            this.beforeDispatchEventArgument = (AWTEvent[])map2.get("event");
            this.beforeDispatchCallable = (Callable)map2.get("method");
            map2 = map.get("getNextEvent");
            this.getNextEventEventQueueArgument = (EventQueue[])map2.get("eventQueue");
            this.getNextEventCallable = (Callable)map2.get("method");
        }

        @Override
        public void afterDispatch(AWTEvent aWTEvent, Object object) throws InterruptedException {
            this.afterDispatchEventArgument[0] = aWTEvent;
            this.afterDispatchHandleArgument[0] = object;
            try {
                this.afterDispatchCallable.call();
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public Object beforeDispatch(AWTEvent aWTEvent) throws InterruptedException {
            this.beforeDispatchEventArgument[0] = aWTEvent;
            try {
                return this.beforeDispatchCallable.call();
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public AWTEvent getNextEvent(EventQueue eventQueue) throws InterruptedException {
            this.getNextEventEventQueueArgument[0] = eventQueue;
            try {
                return this.getNextEventCallable.call();
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

